package w83b.w83bOperacionesPaso.w83bResultados;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bResultadosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaDiferenciasPorConvExcelAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bDiferenciasPorConvenio.xls";
		InputStream inputStream = W83bTablaDiferenciasPorConvExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        Map diferencias = (HashMap)contexto.get("w83bMapResultadosBean");
        W83bResultadosBean resultadoBean = (W83bResultadosBean)contexto.get("w83bResultadosBean");
        
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        HashMap datosDelDep=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);
	   
        HSSFRow row;
        HSSFCell cell;
        HSSFCell cell2;
 
        
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)5);
        
        StringBuffer tituloImagenEs = (StringBuffer)datosDelDep.get("tituloDepEs");
        StringBuffer tituloImagenEu =  (StringBuffer)datosDelDep.get("tituloDepEu");
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)9); 
        cell.setCellValue(tituloImagenEs.toString());
        
        tituloImagenEs = (StringBuffer)datosDelDep.get("tituloDelelegacionEs");
        tituloImagenEu = (StringBuffer)datosDelDep.get("tituloDelelegacionEu");
       
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)5);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)9); 
        sheet.addMergedRegion(new Region(6,Short.parseShort("9"),6,Short.parseShort("10")));//NOPMD
        cell.setCellValue(tituloImagenEs.toString());
        
        row = sheet.getRow((short)10); 
        cell = row.createCell((short)5); 
       
    	if(StringUtils.isNotEmpty(resultadoBean.getFechaHistorico())){
    		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.historicos.afecha",idioma,new String[]{resultadoBean.getFechaHistorico(), resultadoBean.getFeHist()}));
    	}	
        
        row = sheet.getRow((short)11); 
        cell = row.createCell((short)3); 

        cell = row.getCell((short)3); 
        if(StringUtils.isNotEmpty(resultadoBean.getDescTerritorio())){
        	cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(resultadoBean.getDescTerritorio()));
        }
        
        cell = row.createCell((short)6);
       
        cell.setCellValue(resultadoBean.getTerritActaDesde()+"/"+resultadoBean.getAnoActaDesde()+"/"+resultadoBean.getNumActaDesde());
        cell = row.createCell((short)11); 

        cell = row.getCell((short)11); 
        cell.setCellValue(resultadoBean.getTerritActaHasta()+"/"+resultadoBean.getAnoActaHasta()+"/"+resultadoBean.getNumActaHasta());
     
        
        row = sheet.getRow((short)12); 
      
        cell = row.createCell((short)3); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaEleccionDesde())){
        	cell.setCellValue(resultadoBean.getFechaEleccionDesde());
        }
 
        cell = row.createCell((short)6); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaEleccionHasta())){
        	cell.setCellValue(resultadoBean.getFechaEleccionHasta());
        }
        cell = row.createCell((short)11); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaRegistroDefinitivo())){
        	cell.setCellValue(resultadoBean.getFechaRegistroDefinitivo());
        }
        
        cell = row.getCell((short)13);
        if(StringUtils.isNotEmpty(resultadoBean.getConvenioTxt())){
        	cell.setCellValue(resultadoBean.getConvenioTxt());
        }
       
        
        Map mapDiferenciasOrdenado = new TreeMap(diferencias);
        Set ref = mapDiferenciasOrdenado.keySet();
        
      W83bResultadosBean datos;
	  int lineaactual=17;
	  String key="";
	  Iterator it=ref.iterator();
	
	
       while(it.hasNext())
       {
    	  
    	   key=(String)it.next();
    	   datos=(W83bResultadosBean)mapDiferenciasOrdenado.get(key);
    	  
     		row = sheet.createRow((short)lineaactual); 
    	    	   
   	  		cell=row.createCell((short)1);	
   	  		if(StringUtils.isNotEmpty((String)datos.getNregistro())){
   	  			cell.setCellValue((String)datos.getNregistro());
   	  		}
       	  	cell.setCellStyle(estiloFila(lineaactual,excel));
       	  	
   	  	    cell=row.createCell((short)2);	
   	  	    if(StringUtils.isNotEmpty((String)datos.getMunicipio())){
   	  	    	cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel((String)datos.getMunicipio()));
   	  	    }
       	  	cell.setCellStyle(estiloFila(lineaactual,excel));
       	  	
       	  	cell=row.createCell((short)3);
       	  	if(StringUtils.isNotEmpty((String)datos.getComarca())){
       	  		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel((String)datos.getComarca()));
       	  	}
       	  	cell.setCellStyle(estiloFila(lineaactual,excel));
   	  		
       	  	cell=row.createCell((short)4);
       	  	if(StringUtils.isNotEmpty((String)datos.getCodcnae())){
       	  		cell.setCellValue(W83bUtilidades.numero(datos.getCodcnae()));
       	  	}
       	  	cell.setCellStyle(estiloFilaCentrado(lineaactual,excel));
   	  		
       	  	cell=row.createCell((short)5);
       	  	if(StringUtils.isNotEmpty((String)datos.getNacta())){
       	  		cell.setCellValue((String)datos.getNacta());
       	  	}
       	  	cell.setCellStyle(estiloFila(lineaactual,excel));
   	  		
       	  	cell=row.createCell((short)6);
       	  	if(StringUtils.isNotEmpty((String)datos.getAdminemp())){
       	  		cell.setCellValue((String)datos.getAdminemp());
       	  	}
       	  	cell.setCellStyle(estiloFilaCentrado(lineaactual,excel));
       	  	
   	  	    sheet.addMergedRegion(new Region(lineaactual,Short.parseShort("7"),lineaactual,Short.parseShort("8")));//NOPMD
       	  	cell=row.createCell((short)7);
       	  	if(StringUtils.isNotEmpty((String)datos.getCodcolegio())){
       	  		cell.setCellValue((String)datos.getCodcolegio());
       	  	}
       	  	cell.setCellStyle(estiloFilaCentrado(lineaactual,excel));
       	  	cell=row.createCell((short)8);
       	 	cell.setCellStyle(estiloFilaCentrado(lineaactual,excel));
   	  		
       	  	cell=row.createCell((short)9);
       	  	if(StringUtils.isNotEmpty((String)datos.getNumTrabajadores())){
       	  		cell.setCellValue(W83bUtilidades.numero(datos.getNumTrabajadores()));
       	  	}
       	  	cell.setCellStyle(estiloFilaCentrado(lineaactual,excel));
       	  	
       	  	cell=row.createCell((short)10);
       	  	cell2=row.createCell((short)11);
       	  	sheet.addMergedRegion(new Region(lineaactual,Short.parseShort("10"),lineaactual,Short.parseShort("11")));//NOPMD
       	  	if(W83bClsConstantes.CONSTANTE_EUSKARA.equals(idioma))
       	  	{
       	  		if(StringUtils.isNotEmpty((String)datos.getDeseconvenio())){
       	  			cell.setCellValue((String)datos.getDeseconvenio());
       	  		}
       	  	}else{
       	  		if(StringUtils.isNotEmpty((String)datos.getDescconvenio())){
       	  			cell.setCellValue((String)datos.getDescconvenio());
       	  		}
       	  	}
       	    
       	    cell.setCellStyle(estiloFila(lineaactual,excel));
       	    cell2.setCellStyle(estiloFila(lineaactual,excel));
       	    
       	  	cell=row.createCell((short)12);
       	  	if(StringUtils.isNotEmpty((String)datos.getNumdelegados())){
       	  		cell.setCellValue(W83bUtilidades.numero(datos.getNumdelegados()));
       	  	}
       	  	cell.setCellStyle(estiloFilaCentrado(lineaactual,excel));
       	  	
       	  	cell=row.createCell((short)13);
       	  	if(StringUtils.isNotEmpty((String)datos.getSindicatosDeleg())){
       	  		cell.setCellValue((String)datos.getSindicatosDeleg());
       	  	}
   	  	  	cell.setCellStyle(estiloFila(lineaactual,excel));
       	  	
   	  	  
   	  		lineaactual++;
        }
    	     
      
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=ResultadosDiferenciasPorConvenio.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
	private HSSFCellStyle estiloFilaCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParCentrado;
		}else{
			return excel.styleTextoImparCentrado;			
		}
		
	}

	
}
